// PageSettingIP.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageSettingIP.h"
#include "Include\CommonFun.h"
#include "Include\CLS_NVDSDK_Interface.h"


// CPageSettingIP dialog

IMPLEMENT_DYNAMIC(CPageSettingIP, CDialog)

CPageSettingIP::CPageSettingIP(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CPageSettingIP::IDD, pParent)
{

}

CPageSettingIP::~CPageSettingIP()
{
}

void CPageSettingIP::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_IPADDRESS_DECIP, m_CtrlIpAddress);
	DDX_Control(pDX, IDC_IPADDRESS_NETMASK, m_CtrlNetMask);
	DDX_Control(pDX, IDC_IPADDRESS_GATEWAY, m_CtrlGateway);
	DDX_Control(pDX, IDC_IPADDRESS_DNS, m_CtrlDns);
	DDX_Control(pDX, IDC_EDIT_MAC, m_EditMac);
	DDX_Control(pDX, IDC_STC_CHANNEL_NUM, m_stcChannelNum);
	DDX_Control(pDX, IDC_STC_ALARM_IN_NUM, m_stcAlarmInNum);
	DDX_Control(pDX, IDC_STC_ALARM_OUT_NUM, m_stcAlarnOutNum);
	DDX_Control(pDX, IDC_STC_COM_NUM, m_stcComNum);
	DDX_Control(pDX, IDC_STC_SPECIAL_SCREEN_NUM, m_stcSpecialScreenNum);
	DDX_Control(pDX, IDC_STC_CODE_NUM, m_stcCodeNum);
	DDX_Control(pDX, IDC_STC_USB_NUM, m_stcUSBNum);
	DDX_Control(pDX, IDC_EDIT_HTTPPORT, m_EditHttpPort);
	DDX_Control(pDX, IDC_EDIT_HTTPSPORT, m_EditHttpsPort);
	DDX_Control(pDX, IDC_EDIT_RTSPORT, m_EditRtsPort);
	DDX_Control(pDX, IDC_EDIT_SCHEDULEPORT, m_EditScheduleport);
	DDX_Control(pDX, IDC_COMBO_WORKMODE, m_cboWorkMode);
	DDX_Control(pDX, IDC_COMBO_MAINNO, m_cboMainLanNo);
	DDX_Control(pDX, IDC_EDIT_MAC2, m_EditMac2);
}


BEGIN_MESSAGE_MAP(CPageSettingIP, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_SETIP, &CPageSettingIP::OnBnClickedButtonSetip)
	ON_BN_CLICKED(IDC_BUTTON_SETHTTP, &CPageSettingIP::OnBnClickedButtonSethttp)
	ON_BN_CLICKED(IDC_BUTTON_SETLANPARAM, &CPageSettingIP::OnBnClickedButtonSetlanparam)
END_MESSAGE_MAP()


// CPageSettingIP message handlers

void  CPageSettingIP::LoadSurfaceResource()
{
	SetDlgItemText(IDC_STATIC, GetText(IDS_SETTING_GRPNETWORK));
	SetDlgItemText(IDC_STATIC_DECIP, GetText(IDS_SETTING_IPADDRESS));
	SetDlgItemText(IDC_STATIC_NETMASK, GetText(IDS_SETTING_MASK));
	SetDlgItemText(IDC_STATIC_GATEWAY, GetText(IDS_SETTING_GATE));
	SetDlgItemText(IDC_STATIC_DNS, GetText(IDS_SETTING_DNS));
	SetDlgItemText(IDC_STATIC_MAC, GetText(IDS_SETTING_MAC));
	SetDlgItemText(IDC_BUTTON_SETIP, GetText(IDS_SETTING_SETIP));

	SetDlgItemText(IDC_STATIC_LANPARAM, GetTextByLan("ģʽ","Lan Work Mode"));
	SetDlgItemText(IDC_STATIC_WORKMODE, GetTextByLan("ģʽ","Lan Work Mode"));
	SetDlgItemText(IDC_STATIC_MAINNO, GetTextByLan("","Main Lan No"));
	SetDlgItemText(IDC_BUTTON_SETLANPARAM, GetTextByLan("","Set"));
}

int CPageSettingIP::Initialize(TDECPARAM* _pdecParam)
{
	LoadSurfaceResource();
    m_CtrlIpAddress.SetWindowText(CString(_pdecParam->m_ip));
	m_CtrlNetMask.SetWindowText(CString(_pdecParam->m_submask));
	m_CtrlGateway.SetWindowText(CString(_pdecParam->m_gateway));
	m_CtrlDns.SetWindowText(CString(_pdecParam->m_dns));
	m_EditMac.SetWindowText(CString(_pdecParam->m_tMacAddress[0].cMac));
	m_EditMac2.SetWindowText(CString(_pdecParam->m_tMacAddress[1].cMac));
	UpdateTDevInfo();
	UpdateHttpInfo();
	UpdateLanParam();

    return -1;
}

void CPageSettingIP::OnBnClickedButtonSetip()
{
	if (0 > m_lLogonID)
	{
		AfxMessageBox(_T("Please logon the device first"));
		return;
	}
	CString szIp= _T("");
	CString szSubMask = _T("");
	CString szGateway = _T("");
	CString szDns = _T("");
	GetDlgItemText(IDC_IPADDRESS_DECIP, szIp);
	GetDlgItemText(IDC_IPADDRESS_NETMASK, szSubMask);
	GetDlgItemText(IDC_IPADDRESS_GATEWAY, szGateway);
	GetDlgItemText(IDC_IPADDRESS_DNS, szDns);

	if ("" == szIp || "0.0.0.0" == szIp)
	{
		//AfxMessageBox(GetText(IDS_SETTING_IP_INVALID)+GetText(IDS_SETTING_IPADDRESS)+"!");
		MessageBox(GetText(IDS_SETTING_IP_INVALID)+GetText(IDS_SETTING_IPADDRESS)+"!"
			, GetText(IDS_SETTING_GRPNETWORK), MB_OK|MB_TOPMOST);
		return;
	}
	if ("" == szSubMask || "0.0.0.0" == szSubMask)
	{
		//AfxMessageBox(GetText(IDS_SETTING_IP_INVALID)+GetText(IDS_SETTING_MASK)+"!");
		MessageBox(GetText(IDS_SETTING_IP_INVALID)+GetText(IDS_SETTING_MASK)+"!"
			, GetText(IDS_SETTING_GRPNETWORK), MB_OK|MB_TOPMOST);
		return;
	}
	if ("" == szGateway || "0.0.0.0" == szGateway)
	{
		//AfxMessageBox(GetText(IDS_SETTING_IP_INVALID)+GetText(IDS_SETTING_GATE)+"!");
		MessageBox(GetText(IDS_SETTING_IP_INVALID)+GetText(IDS_SETTING_GATE)+"!"
			, GetText(IDS_SETTING_GRPNETWORK), MB_OK|MB_TOPMOST);
		return;
	}
	if ("" == szDns || "0.0.0.0" == szDns)
	{
		//AfxMessageBox(GetText(IDS_SETTING_IP_INVALID)+GetText(IDS_SETTING_DNS)+"!");
		MessageBox(GetText(IDS_SETTING_IP_INVALID)+GetText(IDS_SETTING_DNS)+"!"
			, GetText(IDS_SETTING_GRPNETWORK), MB_OK|MB_TOPMOST);
		return;
	}

	int i1 = 0,i2 = 0,i3 = 0,i4 = 0;
	sscanf_s((LPCSTR)(LPCTSTR)szIp, "%03d.%03d.%03d.%d", &i1, &i2, &i3, &i4);
	if (0 == i4)
	{
		//AfxMessageBox(GetText(IDS_SETTING_IP_INVALID)+GetText(IDS_SETTING_IPADDRESS)+"!");
		MessageBox(GetText(IDS_SETTING_IP_INVALID)+GetText(IDS_SETTING_IPADDRESS)+"!"
			, GetText(IDS_SETTING_GRPNETWORK), MB_OK|MB_TOPMOST);
		return;
	}

	int iRet;
	iRet = DEC_ClientSetIP(m_lLogonID, (LPSTR)(LPCTSTR)szIp
		,(LPSTR)(LPCTSTR)szSubMask, (LPSTR)(LPCTSTR)szGateway
		, (LPSTR)(LPCTSTR)szDns);
	if(iRet==0)
	{
		DEC_ClientRebootDecoder(m_lLogonID);
	}
}

BOOL CPageSettingIP::PreTranslateMessage(MSG* pMsg)
{
	if(pMsg->message == WM_KEYDOWN && (pMsg->wParam == VK_RETURN||pMsg->wParam == VK_ESCAPE)) 
	{ 
		return true;
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void CPageSettingIP::UpdateTDevInfo()
{
	tDevInfo tDevInformation = {0};
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_DEV_INFO, &tDevInformation, sizeof(tDevInfo));
	if (iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgDEVSTUS::OnCbnSelchangeCboChannelNo] DEC_ClientGetDevConfig failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_lLogonID);
		return;
	}
	SetDlgItemInt(IDC_STC_CHANNEL_NUM,tDevInformation.iChanNum);
	SetDlgItemInt(IDC_STC_ALARM_IN_NUM,tDevInformation.iAlarmInNum);
	SetDlgItemInt(IDC_STC_ALARM_OUT_NUM,tDevInformation.iAlarmOutNum);
	SetDlgItemInt(IDC_STC_COM_NUM,tDevInformation.iComNum);
	SetDlgItemInt(IDC_STC_SPECIAL_SCREEN_NUM,tDevInformation.iSplitChanNum);
	SetDlgItemInt(IDC_STC_CODE_NUM,tDevInformation.iEncChanNum);
	SetDlgItemInt(IDC_STC_USB_NUM,tDevInformation.iUsbInterfaceNum);
	SetDlgItemInt(IDC_STC_LOCALINPUTNUM,tDevInformation.iLocalInChnNum);

}

//HTTP˿Ϣ
void CPageSettingIP::UpdateHttpInfo()
{
	DecHttpPort tHttpPort = {0};
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_HTTPPORT, &tHttpPort, sizeof(DecHttpPort));
	if (0 != iRet)
	{
		AddLog(LOG_LEVEL_WARN,"[DEC_ClientGetDevConfig:CMD_DEC_CFG_HTTPPORT] DEC_ClientSetDevConfig failed!Ret(%d),ID(%d)", iRet, m_lLogonID);
		return;
	}
	CString cstrHttpPort;
	CString cstrHttpsPort;
	CString cstrRtsPort;
	CString cstrScheduleport;
	cstrHttpPort.Format("%d",tHttpPort.iPort);
	cstrHttpsPort.Format("%d",tHttpPort.iHttpsPort);
	cstrRtsPort.Format("%d",tHttpPort.iRtsPort);
	cstrScheduleport.Format("%d",tHttpPort.iSchedulePort);

	m_EditHttpPort.SetWindowText(cstrHttpPort);						//HTTP˿
	m_EditHttpsPort.SetWindowText(cstrHttpsPort);					//HTTPS˿
	m_EditRtsPort.SetWindowText(cstrRtsPort);						//RTS˿
	m_EditScheduleport.SetWindowText(cstrScheduleport);				//ڶ˿
}

void CPageSettingIP::OnBnClickedButtonSethttp()
{
	if (0 > m_lLogonID)
	{
		AfxMessageBox(_T("Please logon the device first"));
		return;
	}
	CString szIp= _T("");
	CString szSubMask = _T("");
	CString szGateway = _T("");
	CString szDns = _T("");
	GetDlgItemText(IDC_IPADDRESS_DECIP, szIp);
	GetDlgItemText(IDC_IPADDRESS_NETMASK, szSubMask);
	GetDlgItemText(IDC_IPADDRESS_GATEWAY, szGateway);
	GetDlgItemText(IDC_IPADDRESS_DNS, szDns);


	CString cstrHttpPort;
	CString cstrHttpsPort;
	CString cstrRtsPort;
	CString cstrScheduleport;
	GetDlgItemText(IDC_EDIT_HTTPPORT, cstrHttpPort);
	GetDlgItemText(IDC_EDIT_HTTPSPORT, cstrHttpsPort);
	GetDlgItemText(IDC_EDIT_RTSPORT, cstrRtsPort);
	GetDlgItemText(IDC_EDIT_SCHEDULEPORT, cstrScheduleport);

	if ("" == cstrHttpPort || atoi(cstrHttpPort) <=0 )
	{
	
		MessageBox(GetText(IDS_SETTING_IP_INVALID)+GetText(IDS_EDIT_HTTPPORT)+"!"
			, GetText(IDS_EDIT_HTTPPORT), MB_OK|MB_TOPMOST);
		return;
	}
	if ("" == cstrHttpsPort || atoi(cstrHttpsPort) <=0 )
	{

		MessageBox(GetText(IDS_SETTING_IP_INVALID)+GetText(IDS_EDIT_HTTPSPORT)+"!"
			, GetText(IDS_EDIT_HTTPPORT), MB_OK|MB_TOPMOST);
		return;
	}
	if ("" == cstrRtsPort || atoi(cstrRtsPort) <=0 )
	{

		MessageBox(GetText(IDS_SETTING_IP_INVALID)+GetText(IDS_EDIT_RTSPORT)+"!"
			, GetText(IDS_EDIT_HTTPPORT), MB_OK|MB_TOPMOST);
		return;
	}
	if ("" == cstrScheduleport || atoi(cstrScheduleport) <=0 )
	{
		MessageBox(GetText(IDS_SETTING_IP_INVALID)+GetText(IDS_EDIT_SCHEDULEPORT)+"!"
			, GetText(IDS_EDIT_HTTPPORT), MB_OK|MB_TOPMOST);
		return;
	}

	int i = atoi(cstrHttpPort);
	i = atoi(cstrHttpsPort);
	i = atoi(cstrRtsPort);
	i = atoi(cstrScheduleport);
	int iChannelNo = -1;			//ͨ޹
	DecHttpPort tHttpPort = {0};
	tHttpPort.iSize = sizeof(DecHttpPort);
	tHttpPort.iPort = atoi(cstrHttpPort);
	tHttpPort.iHttpsPort = atoi(cstrHttpsPort);
	tHttpPort.iRtsPort = atoi(cstrRtsPort);
	tHttpPort.iSchedulePort = atoi(cstrScheduleport);

	int iRet = DEC_ClientSetDevConfig(m_lLogonID, iChannelNo, 0, CMD_DEC_CFG_HTTPPORT, &tHttpPort, sizeof(DecHttpPort));
	if (0 != iRet)
	{
		AddLog(LOG_LEVEL_WARN,"[DEC_ClientSetDevConfig:CMD_DEC_CFG_HTTPPORT] DEC_ClientSetDevConfig failed!Ret(%d),ID(%d)", iRet, m_lLogonID);
	}
}

void CPageSettingIP::OnBnClickedButtonSetlanparam()
{
	// TODO: Add your control notification handler code here
	LanParamWorkMode tLanParamWorkMode;
	tLanParamWorkMode.iWorkMode = m_cboWorkMode.GetCurSel();
	tLanParamWorkMode.iMainLanNo = m_cboMainLanNo.GetCurSel();
	int iRet = DEC_ClientSetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_LANPARAM_WORKMODE, &tLanParamWorkMode, sizeof(LanParamWorkMode));
	if (ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_ERROR,"[OnBnClickedButtonSetlanparam:CMD_DEC_CFG_LANPARAM_WORKMODE] DEC_ClientSetDevConfig failed!iRet(%d),ID(%d)", iRet, m_lLogonID);
	}
}
void CPageSettingIP::UpdateLanParam()
{
	LanParamWorkMode tLanParamWorkMode;

	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_LANPARAM_WORKMODE, &tLanParamWorkMode, sizeof(LanParamWorkMode));
	if (ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_ERROR,"[CPageSettingIP::UpdateLanParam:CMD_DEC_CFG_LANPARAM_WORKMODE] DEC_ClientGetDevConfig failed!iRet(%d),ID(%d)", iRet, m_lLogonID);
		return;
	}
	m_cboWorkMode.SetCurSel(tLanParamWorkMode.iWorkMode);
	m_cboMainLanNo.SetCurSel(tLanParamWorkMode.iMainLanNo);
}
void CPageSettingIP::OnParamChangeNotify(_CHANGE_PARAM_NOTIFY_DATA* _pData)
{
	if(NULL == _pData)
		return;
	switch(_pData->m_iMsg)
	{
	case DEC_PARACHANGE_LANPARAM_WORKMODE:
		{
			UpdateLanParam();
		}
		break;
	default:
		break;
	}
}